/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.List;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIBalrogCharge2;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAINearestAttackableTargetTroll;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.fac.LOTRFaction;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityAngbandBalrog
extends LOTREntityNPC {
    public static final IAttribute balrogChargeDamage = new RangedAttribute("lotr.balrogChargeDamage", 2.0, 0.0, Double.MAX_VALUE).func_111117_a("Balrog Charge Damage");
    private int chargeLean;
    private int prevChargeLean;
    public int chargeFrustration = 0;

    public LOTREntityAngbandBalrog(World world) {
        super(world);
        float f = this.getTrollScale();
        this.func_70105_a(2.4f * f, 5.0f * f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIBalrogCharge2(this, 3.0, 20.0f, 200));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new LOTREntityAIAttackOnCollide(this, 1.6, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 24.0f, 0.02f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 16.0f, 0.02f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 12.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.addTargetTasks(true);
        this.spawnsInDarkness = true;
        this.addTargetTasks(true, LOTREntityAINearestAttackableTargetTroll.class);
        this.field_70178_ae = true;
    }

    public float getTrollScale() {
        return 1.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    public int func_70658_aO() {
        return 8;
    }

    @Override
    public float getAlignmentBonus() {
        return 10.0f;
    }

    @Override
    public boolean canReEquipHired(int slot, ItemStack itemstack) {
        return false;
    }

    public boolean isBalrogCharging() {
        return this.field_70180_af.func_75683_a(20) == 1;
    }

    public void setBalrogCharging(boolean flag) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)(flag ? 1 : 0)));
    }

    public float getInterpolatedChargeLean(float f) {
        return ((float)this.prevChargeLean + (float)(this.chargeLean - this.prevChargeLean) * f) / 10.0f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(npcAttackDamage).func_111128_a(10.0);
        this.func_110140_aT().func_111150_b(balrogChargeDamage).func_111128_a(15.0);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        if (this.field_70146_Z.nextBoolean()) {
            this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.swordUtumno));
        } else {
            int i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.swordAngband));
            } else if (i == 1) {
                this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.battleaxeAngband));
            } else if (i == 2) {
                this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.hammerAngband));
            }
        }
        this.npcItemsInv.setIdleItem(this.npcItemsInv.getMeleeWeapon());
        return data;
    }

    @Override
    protected void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        } else {
            this.func_70062_b(0, this.npcItemsInv.getMeleeWeapon());
        }
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.UTUMNO;
    }

    @Override
    public void func_70636_d() {
        block10: {
            super.func_70636_d();
            if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 10 == 0) {
                this.func_70691_i(1.0f);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.chargeFrustration = this.func_70638_az() == null ? 0 : (this.isBalrogCharging() ? 0 : (this.chargeFrustration = this.chargeFrustration + 1));
            }
            this.prevChargeLean = this.chargeLean;
            if (this.isBalrogCharging()) {
                if (this.chargeLean < 10) {
                    ++this.chargeLean;
                }
            } else if (this.chargeLean > 0) {
                --this.chargeLean;
            }
            if (!this.isWreathedInFlame()) break block10;
            if (this.isBalrogCharging()) {
                for (int l = 0; l < 10; ++l) {
                    String s = this.field_70146_Z.nextInt(3) == 0 ? "flame" : "largesmoke";
                    double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 1.5;
                    double d1 = this.field_70163_u + (double)this.field_70131_O * MathHelper.func_82716_a((Random)this.field_70146_Z, (double)0.5, (double)1.5);
                    double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 1.5;
                    double d3 = this.field_70159_w * -2.0;
                    double d4 = this.field_70181_x * -0.5;
                    double d5 = this.field_70179_y * -2.0;
                    this.field_70170_p.func_72869_a(s, d0, d1, d2, d3, d4, d5);
                }
            } else {
                for (int l = 0; l < 3; ++l) {
                    String s = this.field_70146_Z.nextInt(3) == 0 ? "flame" : "largesmoke";
                    double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                    double d1 = this.field_70163_u + 0.5 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O * 1.5;
                    double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                    this.field_70170_p.func_72869_a(s, d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean isWreathedInFlame() {
        return this.func_70089_S() && !this.func_70026_G();
    }

    public void func_70653_a(Entity entity, float f, double d, double d1) {
        super.func_70653_a(entity, f, d, d1);
        this.field_70159_w /= 4.0;
        this.field_70181_x /= 4.0;
        this.field_70179_y /= 4.0;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            List entities;
            EntityLivingBase curTarget = this.func_70638_az();
            if (curTarget != null && entity == curTarget) {
                this.chargeFrustration = 0;
            }
            if (this.func_70694_bm() == null) {
                entity.func_70015_d(5);
            } else if (!entity.func_70027_ad()) {
                entity.func_70015_d(5);
            }
            float attackDamage = (float)this.func_110148_a(LOTREntityNPC.npcAttackDamage).func_111126_e();
            float knockbackModifier = 0.25f * attackDamage;
            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockbackModifier * 0.5f), (double)(knockbackModifier * 0.1f), (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockbackModifier * 0.5f));
            if (!this.field_70170_p.field_72995_K && !(entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, entity.field_70121_D.func_72314_b(4.0, 4.0, 4.0))).isEmpty()) {
                for (Object entitie : entities) {
                    float f;
                    EntityLivingBase hitEntity = (EntityLivingBase)entitie;
                    if (hitEntity == this || hitEntity == entity || !LOTRMod.canNPCAttackEntity(this, hitEntity, false)) continue;
                    float strength = 4.0f - entity.func_70032_d((Entity)hitEntity);
                    strength += 1.0f;
                    if (f > 4.0f) {
                        strength = 4.0f;
                    }
                    if (!hitEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), strength / 4.0f * attackDamage)) continue;
                    float knockback = strength * 0.25f;
                    if (knockback < 0.75f) {
                        knockback = 0.75f;
                    }
                    hitEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f), 0.2 + 0.12 * (double)knockback, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f));
                    if (hitEntity.func_70027_ad()) continue;
                    hitEntity.func_70015_d(5);
                }
            }
            this.field_70170_p.func_72956_a(entity, "lotr:troll.ologHai_hammer", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float f) {
        boolean flag;
        if (damagesource == DamageSource.field_76379_h) {
            return false;
        }
        if (damagesource.func_76355_l().equals("arrow")) {
            f = 2.0f;
        }
        if (flag = super.func_70097_a(damagesource, f)) {
            EntityLivingBase curTarget = this.func_70638_az();
            if (curTarget != null && damagesource.func_76346_g() == curTarget && damagesource.func_76364_f() == curTarget) {
                this.chargeFrustration = 0;
            }
            return true;
        }
        return false;
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killBalrogUtumno;
    }

    @Override
    protected int func_70693_a(EntityPlayer entityplayer) {
        return 15 + this.field_70146_Z.nextInt(10);
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int coals = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)4, (int)(16 + i * 8));
        for (int l = 0; l < coals; ++l) {
            this.func_145779_a(Items.field_151044_h, 1);
        }
        int fires = 1;
        if (i > 0) {
            float x = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)((float)i * 0.667f));
            while (x > 1.0f) {
                x -= 1.0f;
                ++fires;
            }
            if (this.field_70146_Z.nextFloat() < x) {
                ++fires;
            }
        }
        for (int l = 0; l < fires; ++l) {
            this.func_145779_a(LOTRMod.balrogFire, 1);
        }
    }

    @Override
    public void dropNPCEquipment(boolean flag, int i) {
        ItemStack heldItem;
        if (flag && this.field_70146_Z.nextInt(3) == 0 && (heldItem = this.func_70694_bm()) != null) {
            this.func_70099_a(heldItem, 0.0f);
            this.func_70062_b(0, null);
        }
        super.dropNPCEquipment(flag, i);
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        if (!this.field_70170_p.field_72995_K) {
            int exRange = 8;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            for (int i1 = i - exRange; i1 <= i + exRange; ++i1) {
                for (int j1 = j - exRange; j1 <= j + exRange; ++j1) {
                    for (int k1 = k - exRange; k1 <= k + exRange; ++k1) {
                        Block block = this.field_70170_p.func_147439_a(i1, j1, k1);
                        if (block.func_149688_o() != Material.field_151581_o) continue;
                        this.field_70170_p.func_147468_f(i1, j1, k1);
                    }
                }
            }
        } else {
            for (int l = 0; l < 100; ++l) {
                double d = this.field_70165_t + (double)(this.field_70130_N * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)-1.0f, (float)1.0f));
                double d1 = this.field_70163_u + (double)(this.field_70131_O * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)1.0f));
                double d2 = this.field_70161_v + (double)(this.field_70130_N * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)-1.0f, (float)1.0f));
                double d3 = this.field_70146_Z.nextGaussian() * 0.03;
                double d4 = this.field_70146_Z.nextGaussian() * 0.03;
                double d5 = this.field_70146_Z.nextGaussian() * 0.03;
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.field_70170_p.func_72869_a("explode", d, d1, d2, d3, d4, d5);
                    continue;
                }
                this.field_70170_p.func_72869_a("flame", d, d1, d2, d3, d4, d5);
            }
        }
        super.func_70645_a(damagesource);
        this.func_85030_a(this.func_70621_aR(), this.func_70599_aP() * 2.0f, this.func_70647_i() * 0.75f);
    }

    public String func_70639_aQ() {
        return "lotr:troll.say";
    }

    public String func_70621_aR() {
        return "lotr:troll.say";
    }

    protected float func_70599_aP() {
        return 1.5f;
    }

    protected void func_145780_a(int i, int j, int k, Block block) {
        this.func_85030_a("lotr:troll.step", 0.75f, this.func_70647_i());
    }
}

